<?php $__env->startSection('title', translate('Notification_Messages')); ?>
<?php $__env->startSection('notification_message'); ?>
    active
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $user_type = request('message-type') ?? 'user';
    ?>
    
    <div class="content">
        <form action="<?php echo e(route('admin.business-settings.updateFcmMessages')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="page-header pb-0">
                    <div class="d-flex flex-wrap justify-content-between align-items-start">
                        <h1 class="mb-0"><?php echo e(translate('messages.Notification_Messages')); ?></h1>
                    </div>
                    <div class="d-flex flex-wrap justify-content-between align-items-center my-3 gap-3">
                        <div class="js-nav-scroller hs-nav-scroller-horizontal">
                            <!-- Nav -->
                            <?php echo $__env->make('admin-views.business-settings.notification._notification_message_urls', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <!-- End Nav -->
                        </div>
                    </div>

                </div>
                <!-- End Page Header -->
                <div class="d-flex gap-2 fs-12 text-dark px-3 py-2 rounded bg-warning mb-20" style="--bs-bg-opacity: 0.1;">
                    <span class="text-warning lh-1 fs-14">
                        <i class="tio-info"></i>
                    </span>
                    <span>
                        <?php echo e(translate('messages.Setup Push Notification Messages for customer. Must setup')); ?>

                        <a href="<?php echo e(route('admin.business-settings.fcm-index')); ?>"
                            class="text-underline text-primary font-semibold"><?php echo e(translate('messages.Firebase Configuration')); ?>

                        </a>
                        <?php echo e(translate('messages.page to work notifications.')); ?>

                    </span>
                </div>
                <div class="card">
                    <div class="card-header d-flex gap-3 justify-content-between align-items-center flex-wrap">
                        <div>
                            <h3 class="mb-1"><?php echo e(translate('messages.Push_Notification')); ?></h3>
                            <p class="fs-12 mb-0">
                                <?php echo e(translate('messages.Configure and send real-time push notifications to engage users and share important updates.')); ?>

                            </p>
                        </div>
                        <button type="button" data-toggle="modal" data-target="#insertVariableModal"
                            class="btn btn--secondary min-w-120"><?php echo e(translate('messages.Insert_Variable')); ?> </button>
                    </div>
                    <div class="card-body pt-2">
                        <?php ($language = \App\CentralLogics\Helpers::get_business_settings('language')); ?>

                        <div class="mb-3">
                            <?php if($language): ?>
                                <ul class="nav nav-tabs border-bottom overflow-x-auto flex-nowrap text-nowrap">
                                    <li class="nav-item">
                                        <a class="nav-link lang_link active" href="#"
                                            id="default-link"><?php echo e(translate('Default')); ?></a>
                                    </li>
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a class="nav-link lang_link" href="#"
                                                id="<?php echo e($lang); ?>-link"><?php echo e(\App\CentralLogics\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')'); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="bg-light rounded p-12 p-xxl-20">
                            <div class="lang_form" id="default-form">
                                <input type="hidden" name="lang[]" value="default">
                                <input type="hidden" name="user_type" value="<?php echo e($user_type); ?>">
                                <div class="row g-3">


                                    <?php $__currentLoopData = $messageKey; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <div class="col-lg-6">
                                            <div class="form-group mb-0">
                                                <div class="d-flex flex-wrap justify-content-between mb-2">
                                                    <label
                                                        class="input-label text-capitalize d-flex gap-1 align-items-center mb-0">
                                                        <?php echo e(translate($key)); ?>



                                                             <?php if($item  == 'deliveryman_new_order'): ?>
                                                                        <span class="tio-info text-gray1 fs-16"
                                                                            data-toggle="tooltip" data-placement="right"
                                                                            data-original-title="<?php echo e(translate('{userName}_,_{orderld}_,_{restaurantName}_are_supported ')); ?>">
                                                                        </span>
                                                                    <?php else: ?>
                                                                     (<?php echo e(translate('messages.Default')); ?>)
                                                                <?php endif; ?>




                                                    </label>

                                                    <label
                                                        class="switch--custom-label toggle-switch toggle-switch-sm d-inline-flex checked">
                                                        <input type="checkbox" name="<?php echo e($item); ?>_status"
                                                            value="1" id="<?php echo e($item); ?>_status"
                                                            <?php echo e(data_get($notificationMessage, "$item.status") == 1 ? 'checked' : ''); ?>

                                                            data-id="<?php echo e($item); ?>_status" data-type="toggle"
                                                            data-image-on="<?php echo e(dynamicAsset('/public/assets/admin/img/modal/pending-order-on.png')); ?>"
                                                            data-image-off="<?php echo e(dynamicAsset('/public/assets/admin/img/modal/pending-order-off.png')); ?>"
                                                            data-title-on="<?php echo e(translate('By Turning ON Notification Message For')); ?> <strong><?php echo e(translate($item)); ?></strong>"
                                                            data-title-off="<?php echo e(translate('By Turning OFF Notification Message For ')); ?> <strong><?php echo e(translate($item)); ?></strong>"
                                                            data-text-on = "<p><?php echo e(translate($user_type . ' will receive a proper notification message for this event')); ?></p>";
                                                            data-text-off = "<p><?php echo e(translate($user_type . ' will not receive any notification message for this event')); ?></p>";
                                                            class="toggle-switch-input dynamic-checkbox-toggle">
                                                        <span class="toggle-switch-label text">
                                                            <span class="toggle-switch-indicator"></span>
                                                        </span>

                                                    </label>
                                                </div>
                                                <textarea name="<?php echo e($item); ?>[]" class="form-control"
                                                    placeholder="<?php echo e(translate('Ex :')); ?> <?php echo e(translate($key)); ?>"><?php echo e(data_get($notificationMessage, $item)?->getRawOriginal('message')); ?></textarea>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <?php if($language): ?>
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="lang_form d-none" id="<?php echo e($lang); ?>-form">
                                    <div class="row g-3">
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                                                <?php $__currentLoopData = $messageKey; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <?php
                                                    $translate = [];
                                                    $translationData = data_get($notificationMessage, "$item.translations", []);
                                                    if (count($translationData)) {

                                                        foreach ($translationData as $t) {
                                                            if ($t['locale'] == $lang && $t['key'] == $item) {
                                                                $translate[$lang]['message'] = $t['value'];
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-0">
                                                        <div class="d-flex flex-wrap justify-content-between mb-2">
                                                            <label
                                                                class="input-label text-capitalize d-flex gap-1 align-items-center mb-0">
                                                               <?php echo e(translate($key)); ?>


                                                                <?php if($item  == 'deliveryman_new_order'): ?>
                                                                        <span class="tio-info text-gray1 fs-16"
                                                                            data-toggle="tooltip" data-placement="right"
                                                                            data-original-title="<?php echo e(translate('Multi_Language_Not_Available')); ?>">
                                                                        </span>
                                                                    <?php else: ?>
                                                                    (<?php echo e($lang); ?>)
                                                                <?php endif; ?>

                                                            </label>

                                                        </div>
                                                        <textarea name="<?php echo e($item); ?>[]" class="form-control"
                                                            placeholder="<?php echo e(translate('Ex :')); ?> <?php echo e(translate($key)); ?>"><?php echo isset($translate) && isset($translate[$lang]) ? $translate[$lang]['message'] : ''; ?></textarea>
                                                    </div>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-sticky mt-2">
                <div class="container-fluid">
                    <div class="d-flex flex-wrap gap-3 justify-content-center py-3">
                        <button type="reset" id="reset_btn"
                            class="btn btn--secondary min-w-120"><?php echo e(translate('messages.Reset')); ?> </button>
                        <button type="submit" class="btn btn--primary">
                            <i class="tio-save"></i>
                            <?php echo e(translate('Save_Information')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </form>

        <!-- Firebase Modal -->
        <div class="modal fade" id="insertVariableModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true" class="tio-clear"></span>
                        </button>
                    </div>
                    <div class="modal-body text-center pt-0">
                        <h3 class="mb-2"><?php echo e(translate('messages.Insert Variable')); ?></h3>
                        <p class="mb-4">
                            <?php echo e(translate('messages.Provide a pop-up title and subtitle for the push notification.')); ?></p>
                        <div class="d-flex flex-column gap-2 max-h-250 overflow-y-auto">



                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('User')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{userName}')); ?></span>
                            </div>
                            
                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('restaurant')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{restaurantName}')); ?></span>
                            </div>
                            
                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('OrderId')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{orderld}')); ?></span>
                            </div>
                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('Delivery Man Name')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{deliveryManName}')); ?></span>
                            </div>
                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('OTP')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{otp}')); ?></span>
                            </div>

                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('Token Number')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{tokenNumber}')); ?></span>
                            </div>
                            <div
                                class="bg-light rounded p-2 d-flex justify-content-between align-items-center overflow-wrap-anywhere text-dark">
                                <span class="fs-13 font-semibold"><?php echo e(translate('Table Number')); ?></span>
                                <span class="fs-12"><?php echo e(translate('{tableNumber}')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Guidline Offcanvas Btn -->
        <div class="d-flexgap-2 w-40px gap-2 bg-white position-fixed end-0 translate-middle-y pointer view-guideline-btn flex-column pt-3 px-2 justify-content-center offcanvas-trigger"
            data-toggle="offcanvas" data-target="#offcanvasSetupGuide">
            <span class="arrow bg-primary py-1 px-2 text-white rounded fs-12"><i class="tio-share-vs"></i></span>
            <span class="view-guideline-btn-text text-dark font-semibold pb-2 text-nowrap">
                <?php echo e(translate('View_Guideline')); ?>

            </span>
        </div>

        <!-- Guidline Offcanvas -->
        <div id="offcanvasOverlay" class="offcanvas-overlay"></div>
        <div class="custom-offcanvas" tabindex="-1" id="offcanvasSetupGuide" aria-labelledby="offcanvasSetupGuideLabel"
            style="--offcanvas-width: 500px">
            <div>
                <div
                    class="custom-offcanvas-header bg--secondary d-flex justify-content-between align-items-center px-3 py-3">
                    <h3 class="mb-0"><?php echo e(translate('messages.Notification Messages Guideline')); ?></h3>
                    <button type="button"
                        class="btn-close w-25px h-25px border rounded-circle d-center bg--secondary offcanvas-close fz-15px p-0"
                        aria-label="Close">&times;</button>
                </div>
                <div class="custom-offcanvas-body offcanvas-height-100 py-3 px-md-4 px-3">
                    <div class="py-3 px-3 bg-light rounded mb-3 mb-sm-20">
                        <div class="d-flex gap-2 align-items-center justify-content-between overflow-hidden">
                            <button
                                class="btn-collapse d-flex gap-2 align-items-center bg-transparent border-0 p-0 collapsed"
                                type="button" data-toggle="collapse" data-target="#firebase_console"
                                aria-expanded="true">
                                <div
                                    class="btn-collapse-icon w-35px h-35px bg-white d-flex align-items-center justify-content-center border icon-btn rounded-circle fs-12 lh-1">
                                    <i class="tio-down-ui"></i>
                                </div>
                                <span
                                    class="font-semibold text-left fs-14 text-title"><?php echo e(translate('Firebase Console')); ?></span>
                            </button>
                            <a href="<?php echo e(route('admin.business-settings.fcm-index')); ?>"
                                class="text-info text-underline fs-12 text-nowrap"><?php echo e(translate('messages.Let’s Setup')); ?></a>
                        </div>
                        <div class="collapse mt-3" id="firebase_console">
                            <div class="card card-body">
                                <div class="">
                                    <h5 class="mb-2"><?php echo e(translate('Go to Firebase Console')); ?></h5>
                                    <p class="fs-12 mb-1">
                                        <?php echo e(translate('messages.Firebase Console')); ?>

                                    </p>
                                    <ul class="mb-0 fs-12">
                                        <li>
                                            <?php echo e(translate('messages.Open your web browser and go to the Firebase Console')); ?>

                                            <a href="#"
                                                class="text-info">(<?php echo e(translate('messages.https://console.firebase.google.com/')); ?>)</a>.
                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.Select the project for which you want to configure FCM from the Firebase Console dashboard.')); ?>

                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-3 px-3 bg-light rounded mb-3 mb-sm-20">
                        <div class="d-flex gap-2 align-items-center justify-content-between overflow-hidden">
                            <button
                                class="btn-collapse d-flex gap-2 align-items-center bg-transparent border-0 p-0 collapsed"
                                type="button" data-toggle="collapse" data-target="#navigate" aria-expanded="true">
                                <div
                                    class="btn-collapse-icon w-35px h-35px bg-white d-flex align-items-center justify-content-center border icon-btn rounded-circle fs-12 lh-1">
                                    <i class="tio-down-ui"></i>
                                </div>
                                <span class="font-semibold text-left fs-14 text-title"><?php echo e(translate('Navigate')); ?></span>
                            </button>
                            
                        </div>
                        <div class="collapse mt-3" id="navigate">
                            <div class="card card-body">
                                <div class="">
                                    <h5 class="mb-2"><?php echo e(translate('Navigate to Project Settings')); ?></h5>
                                    <ul class="mb-0 fs-12">
                                        <li>
                                            <?php echo e(translate('messages.In the left-hand menu click on the Settings gear icon and then select Project settings from the dropdown.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.In the Project settings page click on the Cloud Messaging tab from the top menu.')); ?>

                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-3 px-3 bg-light rounded mb-3 mb-sm-20">
                        <div class="d-flex gap-2 align-items-center justify-content-between overflow-hidden">
                            <button
                                class="btn-collapse d-flex gap-2 align-items-center bg-transparent border-0 p-0 collapsed"
                                type="button" data-toggle="collapse" data-target="#obtain_info" aria-expanded="true">
                                <div
                                    class="btn-collapse-icon w-35px h-35px bg-white d-flex align-items-center justify-content-center border icon-btn rounded-circle fs-12 lh-1">
                                    <i class="tio-down-ui"></i>
                                </div>
                                <span
                                    class="font-semibold text-left fs-14 text-title"><?php echo e(translate('Obtain All The Information Asked!')); ?></span>
                            </button>
                            
                        </div>
                        <div class="collapse mt-3" id="obtain_info">
                            <div class="card card-body">
                                <div class="">
                                    <h5 class="mb-2"><?php echo e(translate('Go to Firebase Console')); ?></h5>
                                    <ul class="mb-0 fs-12">
                                        <li>
                                            <?php echo e(translate('messages.In the Firebase Project settings page click on the General tab from the top menu.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.Under the Your apps section click on the Web app for which you want to configure FCM.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.Then Obtain API Key FCM Project ID Auth DomainStorage Bucket Messaging Sender ID.')); ?>

                                        </li>
                                    </ul>
                                    <p class="fs-12 mb-0 mt-4">
                                        <?php echo e(translate('messages.Note: Please make sure to use the obtained information securely and in accordance with Firebase and FCM documentation terms of service and any applicable laws and regulations')); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-3 px-3 bg-light rounded mb-3 mb-sm-20">
                        <div class="d-flex gap-2 align-items-center justify-content-between overflow-hidden">
                            <button
                                class="btn-collapse d-flex gap-2 align-items-center bg-transparent border-0 p-0 collapsed"
                                type="button" data-toggle="collapse" data-target="#notification_body"
                                aria-expanded="true">
                                <div
                                    class="btn-collapse-icon w-35px h-35px bg-white d-flex align-items-center justify-content-center border icon-btn rounded-circle fs-12 lh-1">
                                    <i class="tio-down-ui"></i>
                                </div>
                                <span
                                    class="font-semibold text-left fs-14 text-title"><?php echo e(translate('Notification Body')); ?></span>
                            </button>
                            
                        </div>
                        <div class="collapse mt-3" id="notification_body">
                            <div class="card card-body">
                                <div class="">
                                    <h5 class="mb-2"><?php echo e(translate('Write a message in the Notification Body')); ?></h5>
                                    <p class="fs-12 mb-1">
                                        <?php echo e(translate('messages.You can add your message using placeholders to include dynamic content. Here are some examples of placeholders you can use:')); ?>

                                    </p>
                                    <ul class="mb-0 fs-12">
                                        <li>
                                            <?php echo e(translate('messages.{userName}: The name of the user.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{restaurantName}: The name of the restaurant.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{orderld}: The order id')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{deliveryManName}: The name of the delivery man.')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{otp}: The OTP code for order verification')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{tokenNumber}: The Token Number for dine-in')); ?>

                                        </li>
                                        <li>
                                            <?php echo e(translate('messages.{tableNumber}: The Table Number for dine-in')); ?>

                                        </li>



                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    


<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\alab projects\Helo Idly\resources\views/admin-views/business-settings/notification/notification_message.blade.php ENDPATH**/ ?>